import logging
import sys

def setup_logger_to_stdout(level=logging.INFO):
    logger = logging.getLogger("stdout_logger")
    logger.setLevel(level)

    if not logger.handlers:
        handler = logging.StreamHandler(sys.stdout)  
        formatter = logging.Formatter('%(asctime)s - %(levelname)s - %(message)s')
        handler.setFormatter(formatter)
        logger.addHandler(handler)

    return logger